#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "parser.h"

int
parser (int argc, char **argv)
{
  char *op = argv[2];
    
  no_of_args_check(argc);
  
  op_validity_check(op);
  
  char_validity_check(argv, argc);
    
  return 0;
}


void
char_validity_check(char *val[], int argc)
{
  int i;
  int j;
  int MULTIPLE_PERIOD_FLAG = 0; 
 
/* This nested loop reads each char in the strings argv[1] and argv[3], and tests them in three phases */
/*   1 - detects and handles multiple or misplaced minus signs */
/*   2 - filters for any forbidden characters (anything not a number, minus sign or period) */
/*   3 - detects multiple periods in a string */

  for (i = 1; i < argc; i += 2)
    {

      MULTIPLE_PERIOD_FLAG = 0; /* reinitialize period(.) counter for each new string  */
      
      for (j = 0; j < strlen(val[i]); j++)
	{
	  if ((val[i][j]) == '-' && j != 0) /* if detected minus sign is not in first position in string */
	    {
	      fprintf(stderr, "SYNTAX ERROR: Invalid minus-sign\n");
	      exit(1); 
	    }
	      
	  else if (((val[i][j] < '0' || '9' < val[i][j]) /* EXITS if current character is NEITHER a number [0-9] */
		   && val[i][j] != '.') /* NOR a period (.) */ 
		  && val[i][j] != '-')  /* NOR a minus sign(-) */
                                 	    /* This effectively excludes all other characters */
	    {
	      fprintf(stderr, "SYNTAX ERROR in %s\n", val[i]);
	      exit(1);
	    }
	  
	  if (val[i][j] == '.') /* Detects and EXITS on multiple periods(.) in the same string */
	    {
	      MULTIPLE_PERIOD_FLAG++;
	    if (MULTIPLE_PERIOD_FLAG > 1)
	      {
		fprintf(stderr, "SYNTAX ERROR: Too many decimal points\n");
		exit(1);
	      }
	    }
	}
    }
}

void no_of_args_check(int argc)
{
  /* If-statements to exit with an error on invalid number of arguments */
  if (argc < 4)
    {
      fprintf(stderr, "Missing arguments\n");
      exit(2);
    }
  else if (argc > 4)
    {
      fprintf(stderr, "Too many arguments\n");
      exit(2);
    }
}


void 
op_validity_check (char *op)
{
  
  if((op[0] != '+'
      && op[0] != '-'
      && op[0] != 'x'
      && op[0] != '/'
      && op[0] != '%')
     || strlen(op) > 1)
    {
      fprintf(stderr, "SYNTAX ERROR: Invalid operator\n");
      exit(1);
    }
}



